#include "stdio.h"

unsigned fgetrw(stream)
FILE *stream;
{
   unsigned v;
   v = (getc(stream)) << 8;
   v += getc(stream);
   return v;
}

fgetn(d,stream)
char *d;
FILE *stream;
{
   int c;
   do (*d++ = (c = getc(stream))); while (c != '\0');
}

main(argc,argv,envp)
int argc;
char *argv[], *envp[];
{
   int type, atend, bcount, c;
   unsigned v, attr, nblks, cksum;
   char *s, name[16], dirname[16], resname[16];
   long fsize;
   FILE *infile, *outfile=NULL;

   infile = fopen("/dev/fd0.2s","r");
   while (!atend) {
      type = getc(infile);
      switch (type) {

   /* name block */
   case 0377:
	 if (outfile != NULL) {
	    printf("%-14s%10D\n",name,fsize);
	    fclose(outfile);
	 }
	 attr = fgetrw(infile);
	 if (attr & 0004010) nblks = fgetrw(infile);
	 fgetn(name,infile);
	 s = &name[strlen(name)-1];
	 if (*s == '.') *s = '\0';
/*
	 printf("Name block: %s %o %o\n",name,attr,nblks);
*/
	 if (attr & 0006000) {
	    printf("Directories not supported: %s\n",name);
	    exit(-1);
	 } else if (attr & 0010000) {
	    strcat(name,".lk");
	 }
	 if ((outfile = fopen(name,"w")) == NULL) 
	    printf("%s could not be opened\n",name);
	 fsize = 0;
	 break;

   /* data block */
   case 0376:
	 bcount = fgetrw(infile);
	 cksum = fgetrw(infile);
/*
	 printf("Data block: %d %o",bcount,cksum);
*/
	 cksum -= bcount;
	 fsize += bcount;
	 while (bcount-- > 0) {
	    putc(c = getc(infile),outfile);
	    v = c << 8;
	    if (bcount-- > 0) {
	       putc(c = getc(infile),outfile);
	       v += c;
	       cksum -= v;
	    }
	 }
/*
	 printf(" %o\n",cksum);
*/
	 if (cksum != 0) {
	    printf("Checksum error: %s\n",name);
	    unlink(name);
	 }
	 break;

   /* error block */
   case 0375:
	 printf("Error block\n");
	 unlink(name);
	 break;

   /* end block */
   case 0374:
	 printf("End block\n");
	 if (outfile != NULL) {
	    printf("%-16s%-10d\n",name,fsize);
	    fclose(outfile);
	 }
	 exit(0);
	 break;

   /* time block */
   case 0373:
	 fgetrw(infile);
	 fgetrw(infile);
	 fgetrw(infile);
/*
	 printf("Time block\n");
*/
	 break;

   /* link data block */
   case 0372:
	 fgetn(dirname,infile);
	 fgetn(resname,infile);
/*
	 printf("Link data block: %s:%s\n",dirname,resname);
*/
	 if (outfile != NULL) {
	    if (strlen(dirname) != 0) {
	       fprintf(outfile,"%s/%s\n",dirname,resname);
	       printf("%-16s  %s/%s\n",name,dirname,resname);
	    } else {
	       fprintf(outfile,"%s\n",resname);
	       printf("%-16s  %s\n",name,resname);
	    }
	    fclose(outfile); outfile = NULL;
	 }
	 break;

   /* link attribute block */
   case 0371:
	 fgetrw(infile);
	 printf("Link attribute block\n");
	 break;

   default:
	 printf("Unknown block type: %o\n",type);
	 exit(-1);
      }
   }
}
