#include "a.out.h"
#include "stdio.h"

char hexdigits[] = "0123456789ABCDEF";

main(argc,argv)
int argc;
char **argv;
{
   char **arg;
   char *inname;

   inname = "a.out";
   for (arg = argv + 1; *arg != 0; arg++) {
      if (**arg != '-') inname = *arg;
   }
   printf("Converting %s to .COM format\n",inname);
   if (makecom(inname) != 0)
      perror("xcom");
}

makecom(inname)
char *inname;
{
   int inchan, size, n;
   char buffer[512], *p;
   unsigned adr;
   struct exec exec;

   if ((inchan = open(inname,0)) == -1) return(-1);
   if (read(inchan,&exec,sizeof exec) <= 0) return(-1);
   if ((exec.a_magic != A_MAGIC1) || (exec.a_flag != 1)) {
      fprintf(stderr,"xcom: Not a valid program file");
      return(-2);
   }
   size = exec.a_text + exec.a_data - 0x100;
   lseek(inchan,(long) 0x100,1);
   absbeg();
   for (adr = 0; size > 0;) {
      if (read(inchan,p = buffer,sizeof buffer) <= 0) return(-1);
      for (n = sizeof buffer; n > 0; n--)
	 if (size-- > 0) absout(adr++,*p++);
	 else break;
   }
   if (exec.a_bss != 0) {
      absout(adr+exec.a_bss-1,0);
   }
   absdump();
   return(0);
}

unsigned absadr;
char absbuf[32];
int abslen;

absbeg()
{
   absadr = 0;
   abslen = 0;
}

absout(adr,j)
unsigned adr;
int j;
{
   if (abslen == 32 || adr != absadr+abslen) absdump();
   if (abslen == 0) absadr = adr;
   absbuf[abslen++] = j;
}

absdump()
{
   char *p;
   int cksum;

   if (abslen == 0) return;
   putchar(1);
   puthex(absadr>>8); puthex(absadr);
   puthex(abslen);
   for (p = absbuf, cksum = 0; abslen > 0; p++, abslen--) {
      puthex(*p);
      cksum += (*p) & 0xFF;
   }
   puthex(-cksum);
   putchar('\n');
}

puthex(h)
int h;
{
   putchar(hexdigits[(h>>4)&0xF]);
   putchar(hexdigits[h&0xF]);
}
