/*************************************************************************
*
*
*	Name:  ibmtip.h
*
*	Description:  IBM PC specific include file for SForm TIP routines.
*
*
*	History:
*	Date		By		Comments
*
*	04/25/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
************************************************************************/




/*  Notes -

*/

#include	"/sform/src/stip.h"


/* PC extended key codes recognized */
#define	TP_MCU		72
#define	TP_MCD		80
#define	TP_MCL		75
#define	TP_MCR		77
#define	TP_HOME		71
#define	TP_PG_D		81
#define	TP_PG_U		73
#define	TP_EN_D		79
#define	TP_INS		82		/* 'INS' key		*/
#define	TP_DEL		83		/* 'DEL' key		*/
#define	TP_BTAB		15		/* Back Tab			*/

/* waf - Ascii control codes */
#define	TP_BS		8		/* 'Backspace' (???) */
#define	TP_CR		13		/* CR				*/
#define	TP_NL		10		/* NL				*/
#define TP_ESC		27		/* Escape key		*/
#define	TP_QUIT		3		/* Quit (^C)		*/
#define	TP_LCAN		21		/* Line Cancel		*/
#define	TP_BELL		7		/* Bell				*/
#define	TP_FTAB		9		/* Fwd Tab			*/


/* Define 'extended control char' ranges */
#define	TP_FLO		59		/* Function keys */
#define	TP_FHI		68
#define	TP_CCLO		69		/* Control chars */
#define	TP_CCHI		83
#define	TP_SFLO		84		/* Shifted Function keys */
#define	TP_SFHI		93
#define	TP_CFLO		94		/* Control Function keys */
#define	TP_CFHI		103
#define	TP_AFLO		104		/* Alt Function keys */
#define	TP_AFHI		113
#define	TP_ECLO		TP_FLO	/* Lowest defined ext cntrl code */
#define	TP_ECHI		TP_AFHI	/* Highest defined ext cntrl code */

/*************************
**	Display Attributes	**
*************************/


/* Display attribute byte masks.
   These mask values are used by tputc() to implement
   individual attribute selection.
*/


/* 6845 register masks */
#define	AT_FB	'\1'
#define	AT_FG	'\2'
#define	AT_FR	'\4'
#define	AT_FGND	'\7'			/* Forground 'color' */
#define	AT_INT	'\10'			/* Intensity */
#define	AT_BB	'\20'
#define	AT_BG	'\40'
#define	AT_BR	'\100'
#define	AT_BGND	'\160'		/* Background 'color' */
#define	AT_BLNK	'\200'		/* Blinking */
#define	AT_UNDL	AT_FB		/* Underline (normal display only) */
#define	AT_DIM	AT_FGND		/* White chars on black background (dim) */
#define	AT_REV	AT_BGND		/* Black chars on white background (reverse) */
#define	AT_NORM	AT_FGND | AT_INT	/* 'Normal' display attributes */
	/* Note mutually exclusive codes -
	   AT_NORM, AT_DIM, AT_UNDL, AT_REV  */


/* Define display attibute code masks.
   These masks are used to define the symbolic display attribute code.
   The actual byte value to implement an attribute or group of attributes
   is derived from the symbolic attribute code.
   Note - These values must not be changed.
*/
#define		TA_NORM	0		/* Normal		*/
#define		TA_DIM	0x1		/* Dim			*/
#define		TA_UNDL	0x2		/* Underline	*/
#define		TA_BLNK	0x4		/* Blinking		*/
#define		TA_REV	0x8		/* Reverse video */

/* Define attribute arrays.
   The elements are the display attibute byte to implement the display
   attribute defined by the index.
   Attr's marked with '*' are illegal combinations.
*/

/* Monocrome monitor attributes */
static	char	matrlst[]	= {
									/* hex	attr */
	AT_NORM,						/* 0	Normal			*/
	AT_DIM,							/* 1	Dim				*/
	AT_INT | AT_UNDL,				/* 2	Undl			*/
	AT_UNDL,						/**3	Dim, Undl		*/
	AT_NORM | AT_BLNK,				/* 4	Blnk			*/
	AT_DIM | AT_BLNK,				/* 5	Blnk, Dim		*/
	AT_INT | AT_BLNK | AT_UNDL,		/* 6	Blnk, Undl		*/
	AT_BLNK | AT_UNDL,				/* 7	Blnk, Undl, Dim	*/
	AT_REV | AT_INT,				/* 8	Rev				*/
	AT_REV | AT_DIM,				/* 9	Rev, Dim		*/
	AT_REV | AT_INT,				/**a	Rev, Undl		*/
	AT_REV,							/**b	Rev, Dim, Undl	*/
	AT_REV | AT_INT | AT_BLNK,		/* c	Rev, Blnk		*/
	AT_REV | AT_BLNK,				/* d	Rev, Blnk, Dim	*/
	AT_REV | AT_BLNK | AT_INT,		/**e	Rev, Blnk, Undl	*/
	AT_REV | AT_BLNK				/**f	Rev, Blnk, Undl, Dim	*/
	} ;

/* Color monitor attributes */
/* Define attr's for color montor */
#define	AC_NORM		'\17'		/* 'Normal' */
#define	AC_DIM		'\13'		/* 'Dim'	*/
#define	AC_UNDL		'\12'		/* 'Underline */
#define	AC_REV		'\14'		/* 'Reverse' */
static	char	catrlst[]	= {
									/* hex	attr */
	AC_NORM,						/* 0	Normal			*/
	AC_DIM,							/* 1	Dim				*/
	AT_INT | AC_UNDL,				/* 2	Undl			*/
	AC_UNDL,						/**3	Dim, Undl		*/
	AC_NORM | AT_BLNK,				/* 4	Blnk			*/
	AC_DIM | AT_BLNK,				/* 5	Blnk, Dim		*/
	AT_INT | AT_BLNK | AC_UNDL,		/* 6	Blnk, Undl		*/
	AT_BLNK | AC_UNDL,				/* 7	Blnk, Undl, Dim	*/
	AC_REV | AT_INT,				/* 8	Rev				*/
	AC_REV | AC_DIM,				/* 9	Rev, Dim		*/
	AC_REV | AT_INT,				/**a	Rev, Undl		*/
	AC_REV,							/**b	Rev, Dim, Undl	*/
	AC_REV | AT_INT | AT_BLNK,		/* c	Rev, Blnk		*/
	AC_REV | AT_BLNK,				/* d	Rev, Blnk, Dim	*/
	AC_REV | AT_BLNK | AT_INT,		/**e	Rev, Blnk, Undl	*/
	AC_REV | AT_BLNK				/**f	Rev, Blnk, Undl, Dim	*/
	} ;
