/*************************************************************************
*
*
*	Name:  dofld.c
*
*	Description:  Generic field i/o.
*					sfdofld()	- Process next fld.
*
*
*	History:
*	Date		By		Comments
*
*	06/08/84	waf		**  Rev. 2.0  **
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

  The global constant SF_BUFSIZ defines whether scratch data space allocation
  is dynamic or static.
*/

#include	"/sform/src/sfint.h"

#if	(SF_BUFSIZ != -1)
static	char	inpbuf[SF_BUFSIZ] ;		/* static input buffer */
#endif



sfdofld ( fld_desc, mode, data_ptr )
struct SF_FIELD *fld_desc ;
int		mode ;
char	*data_ptr ;		/* ptr to type '?' binary data */
/*
  Synopsis -
	Generic field i/o function.

  Description -
	The st_mdt flag is reset, then the type specific i/o function is invoked.
	Upon return, st_mdt will be set if the fld was modified.
	Certain code(s) are trapped at this level, and the i/o function is re-
	invoked.
	The scratch data space is allocated/assigned at this level. This space
	is used for displaying the (string) fld & entering new (string) fld info.

  Return -
	return val	= SForm completion code.
	st_mdt		- Set if fld modified.

  Notes -
	**> NOTE - In order that the type specific i/o fn's do not have to chk
	for 'Display' mode before updating the binary data, this fn resets the
	st_mdt flag before calling the i/o fn to display/redisplay the fld.
	This is a kludge, but it gives the type specific fn's less to worry about.
*/
{
	register int	sfc ;			/* return code from input fn */
	register int	(*fldio)() ;	/* type specific fld io fn addr */
	char			*tmp_data ;		/* input buf ptr */
	unsigned		flags ;			/* bit flags */
	int				fwid ;
	int				smdt ;
	extern int		sfinitflag ;	/* set if sfinit() has been run */


	/** Houskeeping **/
	/* Be sure sfinit() was run */
	if (sfinitflag == 0)
		sfinit() ;
	/* Save the current fld desc addr */
	sf_curfd = fld_desc ;
	/* Chk for SF_LABELS mode -
	   Convert to SF_DISPLAY */
	if (mode & SF_LABELS) {
		mode |= SF_DISPLAY ;		/* set DISPLAY mode */
		mode &= ~(SF_LABELS) ;		/* reset LABELS mode */
	}

	/* Allocate scratch data area */
	fwid = fld_desc->sf_width ;		/* fld width */
#if	(SF_BUFSIZ != -1)
	tmp_data = inpbuf ;
#else
	sfalloc(fwid) ;
#endif
	tmp_data[fwid] = '\0' ;			/* be sure it's null term'ed */

	/* Get type specific fldio fn ptr */
	/** Note - assumes fn addr is at same offset in ALL fld desc's **/
	fldio = fld_desc->sf_iodata->sf_fldfn ;

	/* Reset the 'fld modified' flag */
	st_mdt = 0 ;


	/** Do the fld i/o **/
	/* Chk for protected fld or 'display only' fld */
	flags = fld_desc->sf_iodata->sf_flags ;		/* bit flags */
	if ((mode & SF_DISPLAY) || (flags & SF_PROTFLD)) {

		/** Display only field **/
		/* Set completion code.
		   Display only ALWAYS returns Next Field */
		sfc = SF_NXTFLD ;
	
	} else {

		/** Edit the field **/
again:
		/* Display & edit the original data. */
		sfc = (*fldio)(fld_desc, mode, data_ptr, tmp_data) ;
		/* Chk comp code */
		switch (sfc) {
			case  SF_RSTFLD :
				/* Restore orig fld & try again */
				st_mdt = 0 ;		/* reset 'modified' flag */
				goto again ;		/* try again */
		}
	}

	/* Display/Redisplay the (possibly modified) data fld.
	   Note that sfc has already been set.
	   Note that the 'fld modified' flag is temporarily reset, so that
	   the i/o fn does not try to update the binary data. */
	smdt = st_mdt ;					/* save flag */
	st_mdt = 0 ;					/* reset flag */
	(*fldio)(fld_desc, SF_DISPLAY, data_ptr, tmp_data) ;	/* display fld */
	st_mdt = smdt ;					/* restore flag */


	/* Free the dynamic memory */
#if	(STATMEM == 0)
	free(tmp_data) ;
#endif

	/* Return the completion code */
	return(sfc) ;
}



#if	(SF_BUFSIZ == -1)
sfalloc ( fwid )
int		fwid ;
/*
  Allocate dynamic scratch data space.
*/
{
	register char	*sdptr ;

	sdptr = malloc(fwid + 1) ;
	if (sdptr == 0)
		sfpanic("malloc() error.") ;
	return(sdptr) ;
}
#endif
