/*************************************************************************
*
*
*	Name:  setsig.c
*
*	Description:  Sets all signals for capture by the p-machine
*
*
*	History:
*	Date		By	Comments
*
*	03/23/83	mas
*	09/02/83	waf	Return NORM_XIT code in pexit() call.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH*/

#include <signal.h>
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pexit.h"

int	(*oldsig)(); /* if set to SIG_IGN, then running in background */


setsig ()
{

	int	onikey1(),onikey2();
	int	onalarm();
	int	sexit();

	/* turn off signals until ready */
	oldsig = signal(SIGINT, SIG_IGN);
	if (oldsig != SIG_IGN) {
		signal(SIGINT,onikey1);
		signal(SIGQUIT,sexit);
		}

	/* set to cause all signals to clean up terminal and signals */
	signal(SIGHUP,sexit);
	signal(SIGTERM,sexit);

	/* clear interrupt flags */
	ust.alarmflag = FALSE;
	ust.stxfl.sxflag = FALSE;
	ust.flag2 = FALSE;

	/* no jump frames set yet */
	valikey = FALSE;
	valalarm = FALSE;

	signal(SIGALRM, onalarm); 		/* set alarm routine */

	return;
	}

/*
	Signal exit - calls pexit with 0
*/
sexit ()
{
	pexit(NORM_XIT);
	}
