/*************************************************************************
*
*
*	Name:  pinit.c
*
*	Description:  Initializes the p-machine
*
*
*	History:
*	Date		By	Comments
*
*	04/21/83	mas	This used to be in pmach.c but the optimizer
*				ran out of space so pmach.c had to be made
*				smaller
*	06/22/83	mas	added open of error file and special number
*				file
*	6/24/83 	mas	changed to use registers where possible
*	6/27/83		mas	added registers where possible
*	07/28/83	mas	initialize pushstk
*	09/02/83	waf		Return SYSER_XIT code to pexit() on init error.
*	11/18/83	waf		Initialize basheader values.
*	12/06/83	waf		Created resetgf() to reset frame ptrs.
*	12/15/83	waf		Created DGFinit() to init dummy global frame and
*					then call resetgf().
*	02/24/84	waf		Zero fill minor revision number
*					and fix copyright notice.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

12/6/83		waf
  The resetgf() fn is used by readpc.c code to 'reset' the frame ptrs while pgm
code is being loaded. This causes ikeys & errors to be trapped until the frame
ptrs are set to 'real' values. The 'dummy' global frame is initialized in the
pinit() code.


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/prevision.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pexit.h"

pinit (argc,argv)
int	argc;
char	*argv[];
{
	register int	i;
	register char	*cp ;
	char	tempbuf[32];
	unsigned	minrev ;

	if (argc < 2 || argc > 4) {

		/* no arguments in cmd line - show message */
		cp = "bb Revision X86-" ;
		write(1, cp, strlen(cp)) ;
		cbdl(tempbuf,(long)((REVISION >> 8)&0x00ff),0);
		write(1,tempbuf,strlen(tempbuf));
		write(1,".",1);
		minrev = REVISION & 0xff ;		/* minor rev */
		cbdl(tempbuf,(long)minrev,0);
		if ( minrev < 10 )
			write(1,"0",1) ;		/* zero fill */
		write(1,tempbuf,strlen(tempbuf));
		cp = "\nCopyright (c) 1983, 1984 by Digital Communications Assoc.\n" ;
		write(1, cp, strlen(cp)) ;
		cp = "Usage: bb progfile [9999] [-cd] [+pushfile]\n" ;
		write(1, cp, strlen(cp)) ;
		exit(-1);
		}

	pmdsw = FALSE;		/* no pmdump on errors and stop */
	valikey = FALSE;	/* no long jump on int */
	valalarm = FALSE;	/* no long jump on alarm */
	tracefd = 2;		/* set to stderr */
	penviron = 0x4001;	/* set environ flag */

	numfd = IDLE;		/* IDLE both special files */
	errfd = IDLE;

	pushstk[0] = pushstk[1] = 0L;	/* set first locations to 0 */

	DGFinit();		/* init dummy global frame & set GFP to point to it */

	terminit();		/* initialize terminal */

	getterm();		/* set default terminal type */

	setsig();		/* capture all signals */

	/* ERROR during initialization returns here */
	if ((i = setjmp(errenv)) != 0) {
		errz(i,0,0); /* go get user error routine */
		pexit(SYSER_XIT);
		}

	bbpath = getenv("BBPATH");	/* get bb path list */

	ustinit();		/* initialize User Status Table */

	parsecmd(argc,argv);	/* parse commands and set switches */

	openpush();		/* open push file */

	openlib();		/* open system library */


	/* Load program */
	clearbase();		/* set 'no base pgm resident' */
	readpc(ust.pname);	/* get program code */


	/* open error file */
	if ((errfd = open(xerrfile,0)) < 0)
		errfd = IDLE;	/* can't open error file */

	/* open special number file */
	if ((numfd = open(xnumfile,2)) < 0)
		numfd = IDLE;	/* can't open number file */

	return;
	}

static	DGFinit ()

/* set up dummy global & system frames & init GFP to point to dummy global
   frame.

  The 'dummy' global frame is used to 'disable' use of the global frame
  data at times when the info in the frame may be uninitialized, not
  updated, or incorrect.
  This is true, for example, when program code is being loaded into memory.
  In particular; using the old pc offset with a new line# table will give
  strange line #'s, and the vector for a trapped ikey or error will be bad
  if new code has been loaded.
*/
{


	/* init dummy system frame */
	DSF.SERRVEC.B = (char *) -2 ;  /* these cause IKEYS and ERRORS to exit */
	DSF.SINTVEC.B = (char *) -2 ;

	/* init dummy global frame */
	DGF.SGFP.B = (char *)&DSF;		/* ptr to dummy sys frame */
	DGF.ERRVEC.B = (char *)-1;		/* these will 'fall through' to the
	DGF.INTVEC.B = (char *)-1;		/*   dummy sys frame vectors. */
	DGF.LTP = (char *) 0 ;			/* flag 'non-current' line# table */

	resetGFP() ;	/* set global frame ptrs to dummy values */
	}



resetGFP ()

/* 'Reset' Global Frame Pointer.

   The ptrs are set to dummy values which will insure error & ikey traps.
   'DGF' has been previously set to dummy values.
*/
{


	GFP = &DGF;						/* GFP -> dummy global frame */
	}
