/*************************************************************************
*
*
*	Name:  pend.c
*
*	Description:  Does the PEND function
*
*
*	History:
*	Date		By	Comments
*
*	04/20/83	mas
*	07/28/83	mmas	changed to use pushstk for location in 
*				push file
*	09/02/83	waf	Pass NORM_XIT code to pexit().
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/pexit.h"

extern long lseek();

pend ()
{
	int	i;
	long	l,m;

	if (ust.stxfl.trace == TRUE) {
		write(tracefd,"\nEND\n",5);
		i = tracefd;
		tracefd = -1;
		ptrace();
		tracefd = i;
		}

	if (ust.pushcnt == 0)
		pexit(NORM_XIT);

	--ust.pushcnt;

	l = pushstk[ust.pushcnt];	/* get push location */

	if ((m = lseek(pushfd,l,0)) < 0) {
		bberr(BESWP);
		}

	reloadpc(pushfd,l);

	TPC = pcheader.pc.B;
	TSP = pcheader.sp.B;

	startline = 0;

	return;
	}

