0005 Rem - FILESORT.bb
: !P_FILESORT 
:
: FILE SORT ALLOWING MULTIPLE KEY FIELDS
:     USING SHELL SORTING ALGORITHM
:
: REV:  1.00 - 09/08/75
:       1.01 - 09/26/75 (0278-0314) ERR IN INDEXING FIELD TABLE
:       1.03 - 11/12/76 ALLOW DELETED RECORDS TO BE SORTED TO END OF FILE
:                       MODIFY ALGORITHM TO CACM #201 SHELL/BADEN
:       1.04 - 07/02/79 ADD STMA 1,1,E ERROR RETURN
:
: FILE SORT ARGUMENTS PASSED IN COMMON
:
:  1, 1  (1) CHANNEL # OF FILE TO BE SORTED
:  2, 5  (4) # OF RECORDS TO BE SORTED
:  6, 7  (2) RECORD SIZE IN BYTES
:  8,11  (4) BYTE OFFSET TO FIRST RECORD
: 12,12  (1) SORT MODIFIERS
:               1B0 - SORT DELETED RECORDS TO END OF FILE
: 13,13  (1) # OF KEY FIELDS IN RECORD
:        (5) KEY FIELD DESCRIPTORS
: 14,15  (2)   FIRST BYTE OF KEY
: 16,17  (2)   LAST BYTE OF KEY
: 18,18  (1)   KEY TYPE
:               1B0 - SORT FIELD IN DESCENDING ORDER
:               1B1 - SIGNED BINARY FIELD
:              B7-2 - SUBROUTINE VECTOR FOR SPECIAL COMPARE ROUTINE(S)
: 19-    (5) NEXT KEY FIELD[S]
:
: RETURNED ARGUEMENTS
:
:  1, 2  (2) ERROR CODE
:               0 = OK
:              -N = RDOS/BASIC I/O ERROR
:              +N = BASIC ERROR
: ABOVE ERROR ALSO RETURNED IN STMA 1,1,E
: ********************************************************************
:
0010 ON ERR THEN GOTO 0600
:
0100 DIM X$[512]                      :MUST BE BIG ENOUGH FOR READ COMMON
0101 REM FILESORT REV: 1.04 : 1.03 (11/12/76)
0105 LET DLROK%=1
0110 LET ERCODE%=0                    :CLEAR ERROR FLAG
0200 BLOCK READ X$                    :GET ARGUEMENTS
0220 LET CHNO%=ASC(X$[1,1])           :CHANNEL #
0230 UNPACK "L",X$[2,5],NREC          :# OF RECS
0235 IF NREC<=1 THEN GOTO 0400        :ANY RECS TO SORT?
0240 LET RSIZE%=ASC(X$[6,7])          :REC SIZE
0250 UNPACK "L",X$[8,11],FILDSP       :FILE DISPLACEMENT
0260 IF AND(1,ASC(X$[12,12])) THEN LET DLROK%=0    :CHECK FOR DELETED RECS
0270 LET NKEYS%=ASC(X$[13,13])-1      :NUMBER OF KEYS
0275 DIM FLDTBL%[NKEYS%,2]            :KEY DESC TABLE
0278 LET I0%=0                        :INIT FIELD POINTER
0280 FOR FLDNO%=14 TO NKEYS%*5+14 STEP 5           :GET KEY FIELD DESCRIPTIONS
0290   LET FLDTBL%[I0%,0]=ASC(X$[FLDNO%+4,FLDNO%+4])   :FIELD TYPE
0300   LET FLDTBL%[I0%,1]=ASC(X$[FLDNO%,FLDNO%+1])     :FROM LOC
0310   LET FLDTBL%[I0%,2]=ASC(X$[FLDNO%+2,FLDNO%+3])   :TO LOC
0314   LET I0%=I0%+1                  :BUMP FIELD POINTER
0320 NEXT FLDNO%
0350 GOSUB 8000                       :SORT!
0400 DIM X$[512]                      :SET SIZE FOR WRITE COMMON
0410 LET X$=CHR$(ERCODE%,2),FILL$(0)  :RETURN ERROR CODE
0420 BLOCK WRITE X$
0430 STMA 2,1,ERCODE%                 :ALSO SET STMA FOR ERROR CODE/DONE
0500 END                              :DONE
:
: ERROR RETURN
0600 LET ERCODE%=SYS(7)               :GET ERROR #
0610 STMA 8,0                         :CLEAR STACKS
0620 STMA 2,1,ERCODE%                 :RETURN ERROR CODE
0630 GOTO 0400
:
: FILE SORT USING SHELL ALGORITHM
8000 DIM X$[RSIZE%],Y$[RSIZE%]
8010 LET SPAN=0                      :FIND SPAN=1 LESS THAN LEAST POWER OF 2>NREC
8020 LET SPAN=SPAN+SPAN+1
8030 IF SPAN<NREC THEN GOTO 8020
8040 LET SPAN=SPAN/2                 :BEGIN OUTER LOOP, HALVE SPAN
8050 IF SPAN<=0 THEN RETURN          :END OUTER LOOP? Y=DONE
8060 LET NSETS=NREC-SPAN             :LIMIT FOR MIDDLE LOOP
8070 FOR ISET=1 TO NSETS
8080   FOR LRECN=ISET TO 1 STEP -SPAN    :INNER LOOP
8130     LET LRECP=(LRECN-1)*RSIZE%+FILDSP    :LOWER RECORD TO COMPARE
8140     POSITION FILE[CHNO%,LRECP]
8150     READ FILE[CHNO%],X$
8160     LET URECN=LRECN+SPAN            :UPPER RECORD TO COMPARE
8170     LET URECP=(URECN-1)*RSIZE%+FILDSP
8180     POSITION FILE[CHNO%,URECP]
8190     READ FILE[CHNO%],Y$
8200     GOSUB 8350                   :COMPARE ROUTINE
8205     IF SWPFLG% THEN GOTO 8270    :COMPLETE INNER LOOP IF SWAP INDICATED
8210     POSITION FILE[CHNO%,LRECP]      :REWRITE RECORDS IN OPPOSITE LOCATIONS
8220     WRITE FILE[CHNO%],Y$
8230     POSITION FILE[CHNO%,URECP]
8240     WRITE FILE[CHNO%],X$
8260   NEXT LRECN                    :END INNER LOOP
8270 NEXT ISET                       :END MIDDLE LOOP
8280 GOTO 8040                       :END OUTER LOOP
:
:     RECORD COMPARISON ROUTINE, CHECKS FIELD BY FIELD
8350 LET SWPFLG%=1                    :SET NO SWAP FLAG
8351 IF DLROK% THEN GOTO 8360
8352 IF Y$[1,2]="<0><0>" THEN RETURN 
8353 IF X$[1,2]<>"<0><0>" THEN GOTO 8360
8354 LET SWPFLG%=0
8355 RETURN 
8360 FOR FLDNO%=0 TO NKEYS%               :CHECK ALL FIELDS TILL MIS-MATCH
8370   LET FLDTYP%=FLDTBL%[FLDNO%,0]      :FIELD TYPE
8380   LET FLDBGN%=FLDTBL%[FLDNO%,1]      :FROM LOC
8390   LET FLDEND%=FLDTBL%[FLDNO%,2]      :TO LOC
:
:      ON SHFT(FLDTYP%,-2) GOTO - - SPECIAL COMPARE ROUTINE
:                                      MUST BE SUPPLIED BY USER
:
8400   IF AND(FLDTYP%,2)=0 THEN GOTO 8460      :UNSIGNED FIELD
8410   IF AND(ASC(X$[FLDBGN%,FLDBGN%]),128) THEN GOTO 8440     :NEG
8420   IF AND(ASC(Y$[FLDBGN%,FLDBGN%]),128) THEN GOTO 8520     :NEG - X>Y
8430   GOTO 8460                      :BOTH POS - NORMAL COMPARE
8440   IF AND(ASC(Y$[FLDBGN%,FLDBGN%]),128)=0 THEN GOTO 8500   :POS - X<Y
8460   IF X$[FLDBGN%,FLDEND%]>Y$[FLDBGN%,FLDEND%] THEN GOTO 8520        :X>Y
8470   IF X$[FLDBGN%,FLDEND%]<Y$[FLDBGN%,FLDEND%] THEN GOTO 8500        :X<Y
8480 NEXT FLDNO%                          :EQUAL - NEXT FIELD
8490 RETURN                           :ALL EQUAL - DONE
8500 IF AND(FLDTYP%,1) THEN LET SWPFLG%=0      :X<Y - SET SWAP IF DESCENDING
8510 RETURN 
8520 IF AND(FLDTYP%,1)=0 THEN LET SWPFLG%=0    :X>Y - SET SWAP IF ASCENDING
8530 RETURN 

