	TITLE	'CDCBOOT -- CDC PHOENIX CPM/MPM BOOTSTRAP'

;	08-03-81



;   'CDCBOOT' IS USED TO BOOT EITHER A CP/M OR AN MP/M OPERATING
;   SYSTEM FROM TRACK ZERO OF A CDC PHOENIX (CMD) HARD DISK DRIVE.
;   AN XCOMP SMS/SMR CONTROLLER IS USED.
;
;   YOU MAY WISH TO ADD SOME CODE TO THE ERROR ROUTINE 'ERROR'
;   IN ORDER TO REPORT ERRORS TO THE OPERATOR.




;	---PROGRAM CONFIGURATION---
;
;
;   THE FOLLOWING STATEMENTS ARE USED TO CONFIGURE THE PROGRAM.
;
;	1. TEST - SET THIS 'FALSE' BEFORE USING THE PROGRAM.
;
;	2. ENBINT - SET THIS 'TRUE' IF YOU NEED INTERRUPTS ENABLED
;	   WHILE RUNNING THE PROGRAM. SET THIS 'FALSE' IF YOU DO
;	   NOT USE INTERRUPTS.
;
;	3. S100 - SET THIS 'TRUE' IF YOU ARE USING A CONTROLLER WITH
;	   AN S100 BUS INTERFACE (SMS). SET THIS 'FALSE' IF YOU ARE
;	   USING A CONTROLLER WITH A RIBBON CABLE INTERFACE (SMR).
;
;	4. BTCPM - SET THIS 'TRUE' IF YOU ARE BOOTING A CPM SYSTEM.
;	   SET THIS 'FALSE' IF YOU ARE BOOTING AN MPM SYSTEM.
;
;
FALSE	EQU	0		;DEFINE FALSE
TRUE	EQU	NOT FALSE	;..TRUE
;
TEST	EQU	FALSE		;NOT TESTING
;
ENBINT	EQU	FALSE		;WE DON'T USE INTERRUPTS
;
S100	EQU	TRUE		;S-100 BUS CONTROLLER (SMS)
;
BTCPM	EQU	TRUE		;BOOTING CPM




;	---EQUATES---
;
;
	IF	BTCPM		;  ** IF BOOTING CPM **
MSIZE	EQU	62		;MEMORY SIZE IN K-BYTES
BIAS	EQU	(MSIZE-20)*1024	;SYSTEM BIAS
CPM	EQU	BIAS+3400H	;CPM LOAD ADDRESS
BIOS	EQU	CPM+1600H	;COLD BOOT ENTRY POINT
OFFSET	EQU	1F80H-BIOS	;SYSGEN OFFSET
LDADR	EQU	CPM		;LOAD ADDRESS
ENTRY	EQU	BIOS		;ENTRY POINT
NSECT	EQU	30		;NUMBER OF SECTORS TO READ
	ENDIF
;
	IF	NOT BTCPM	;  ** IF BOOTING MPM **
LDADR	EQU	100H		;LOAD ADDRESS
ENTRY	EQU	100H		;ENTRY POINT
NSECT	EQU	30		;NUMBER OF SECTORS TO READ
	ENDIF
;
STRT	EQU	0		;PROGRAM START ADDRESS
STACK	EQU	STRT+100H	;STACK POINTER
DEBUG	EQU	0F000H		;DEBUG ENTRY POINT
TRAP	EQU	0F01EH		;DEBUG TRAP ADDRESS
;
RPT	EQU	80H		;REPEAT
INDEX	EQU	10H		;INDEX BIT
RCA	EQU	0EAH		;READ COMPARE ADDRESS
RSA	EQU	0CCH		;READ START ADDRESS
;
;   CONTROLLER COMMANDS
;
BANK0	EQU	0		;BANK 0 SELECT
BANK1	EQU	1		;BANK 1 SELECT
DBENB	EQU	2		;DATA BUFFER ENABLE
CBENB	EQU	4		;COMPARE BUFFER ENABLE
START	EQU	8		;START COMMAND
;
;   DRIVE COMMANDS
;
D@CLR	EQU	10H		;FAULT CLEAR
D@TKZ	EQU	40H		;REZERO
;
;   DRIVE TAGS
;
DSTAG	EQU	1		;DRIVE SELECT TAG
TAG1	EQU	2+1		;  TAG1
TAG2	EQU	4+1		;  TAG2
TAG3	EQU	8+1		;  TAG3
;
;   DRIVE/CONTROLLER I/O
;
CBASE	EQU	70H		;BASE ADR OF THE CONTROLLER
	IF	S100	;  ** IF S-100 INTERFACE **
DRCSR	EQU	CBASE		;DRIVE COMMAND/STATUS
CBL	EQU	CBASE+1		;COMMAND BUS, LSB
CBH	EQU	CBASE+2		;  * MSB
DRSB	EQU	CBASE+3		;DRIVE SELECT BITS
CTCSR	EQU	CBASE+4		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+5		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+6		;CONTROLLER DATA PORT
CLRSEK	EQU	CBASE+7		;CLEAR SEEK END F/F
	ELSE		;  ** IF RIBBON CABLE INTERFACE **
DRCSR	EQU	CBASE+7		;DRIVE COMMAND/STATUS
CBL	EQU	CBASE+6		;COMMAND BUS, LSB
CBH	EQU	CBASE+5		;  * MSB
DRSB	EQU	CBASE+4		;DRIVE SELECT BITS
CTCSR	EQU	CBASE+3		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+2		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+1		;CONTROLLER DATA PORT
CLRSEK	EQU	CBASE		;CLEAR SEEK END F/F
	ENDIF

	PAGE

	ORG	STRT



;	---PROGRAM ENTRY POINT---
;
;
BOOT:	LXI	SP,STACK	;SET SP
;
;   BOOT LOOP
;
LOOP:	LXI	H,LDADR		;LOAD ADDRESS
	SHLD	DMADR		;SET DMA ADR
	LXI	H,SECTOR
	MVI	M,1		;SET SECTOR ADR
	INX	H
	MVI	M,NSECT		;SET SECTOR COUNT
;
L1:	CALL	READ		;READ A SECTOR
	JNZ	ERROR		;JIF READ FAILED
;
	MVI	A,DBENB
	OUT	CTCSR		;ENB DATA BFR
	XRA	A
	OUT	CTBFR		;SET BFR ADR = 0
	MOV	B,A		;B = COUNT (256)
	LHLD	DMADR		;H/L = DMA ADR
	IN	CTDP		;PRIME INPUT DATA
L2:	IN	CTDP		;GET DATA FROM BFR
	MOV	M,A		;PUT DATA INTO RAM
	INX	H
	DCR	B
	JNZ	L2
;
	SHLD	DMADR		;SAVE NEW DMA ADR
	LXI	H,SECTOR
	INR	M		;INCR SECTOR ADR
	INX	H
	DCR	M		;DECR LOOP COUNT
	JNZ	L1		;JIF MORE TO DO
;
	IF	TEST
	JMP	DEBUG		;IF WE ARE TESTING
	ELSE
	JMP	ENTRY		;GOTO ENTRY POINT
	ENDIF





;	---READ A SECTOR---
;
;
READ:	MVI	D,10		;D = RETRY COUNT
	MVI	A,CBENB
	OUT	CTCSR		;SLCT BANK0 CMP BFR
	MVI	A,RCA+3
	OUT	CTBFR		;SET BFR ADR
	LDA	SECTOR
	OUT	CTDP		;SET SECTOR ADR FOR CMP
;
RD1:	CALL	RDY		;DRIVE READ ?
	RNZ			;RIF DRIVE NOT RDY
	XRA	A
	OUT	CBH
	OUT	CBL		;CLEAR CMD BUS
	OUT	CTCSR		;SLCT BANK0
	MVI	A,RSA
	OUT	CTBFR		;SET CMD BFR ADR
	MVI	A,TAG3
	OUT	DRCSR		;SET TAG3
	MVI	A,START
	OUT	CTCSR		;START READ
;
RD2:	IN	CTCSR		;CTLR STATUS
	RRC
	JNC	RD2		;WAIT FOR DONE
	NOP			;DELAY FOR H/W
	IN	CTCSR		;GET NON-CHANGING STATUS
	MOV	B,A		;   SAVE IT
	XRA	A
	OUT	CTCSR		;STOP CTLR
	INR	A
	OUT	DRCSR		;CLEAR TAG3
	MOV	A,B
	ANI	0EH		;TEST CTLR STATUS (0=OK)
	MOV	B,A
	IN	DRCSR		;DRIVE STATUS
	ANI	10H
	CNZ	CLRDF		;CIF CLEAR DRIVE FAULT
	ORA	B		;SET/CLEAR ERROR FLAG (0=OK)
	RZ			;RIF READ/WRITE OK
	DCR	D		;DECR RETRY COUNT
	JNZ	RD1		;JIF RETRY READ
	MVI	A,2		;A = ERROR CODE
	ORA	A		;SET 8080 FLAGS
	RET




;	---DRIVE READY TEST---
;
;
RDY:	IN	DRCSR		;DRIVE STATUS
	ANI	9		;'UNIT SLCT'  &  'DRIVE RDY'
	XRI	9		;INVERT BOTH
	RZ			;RIF DRIVE READY
	MVI	A,1		;A = ERROR CODE
	ORA	A		;SET 8080 FLAGS
	RET




;	---CLEAR DRIVE FAULT---
;
;
CLRDF:	XRA	A
	OUT	CBH
	MVI	A,D@CLR
	OUT	CBL		;SET CMD BUS = FAULT CLEAR
	MVI	A,TAG3
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG3
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG3
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	RET




;	---UNRECOVERABLE ERRORS---
;
;   UNRECOVERABLE ERRORS COME HERE WITH AN ERROR
;   CODE IN 'A'.
;
;	A = 1	DRIVE NOT READY
;	  = 2	UNRECOVERABLE READ ERROR
;
;
ERROR	EQU	$
	IF	TEST		;IF WE ARE TESTING
	CALL	TRAP		;TRAP TO DEBUGGER
	ENDIF
	JMP	ERROR		;   ** ADD SOME CODE HERE **




;	---STORAGE---
;
;
DMADR:	DS	2		;DMA ADDRESS
SECTOR:	DS	1		;SECTOR ADDRESS
SCNT:	DS	1		;SECTOR COUNT



	END
