;---DATE 30AUG85 1723
; MDM7xxSS.ASM -- Adv'd Digital SSlave file for MDM7xx.  08/30/85
;
; You will want to look this file over carefully. There are a number of
; options that you can use to configure the program to suit your taste.
; This file adapts the ADC-SS computer to the modem program.  Much of
; the information contained here is not in the MDM7xx.ASM file.
;
; Edit this file for your preferences then follow the "TO USE:" example
; shown below.
;
; Use the "SET" command to change the baudrate when desired.  It starts
; out at 9600 baud when the program is first called up.
;
;	TO USE: First edit this file filling in answers for your own
;		equipment.  Then assemble with ASM.COM or equivalent
;		assembler.  Then use DDT to overlay the the results
;		of this program to the original .COM file:
;
;		A>DDT MDM7xx.COM
;		DDT VERS 2.2
;		NEXT  PC
;		4300 0100
;		-IMDM7xxSS.HEX		(note the "I" command)
;		-R			("R" loads in the .HEX file)
;		NEXT  PC
;		4300 0000
;		-G0			(return to CP/M)
;		A>SAVE 66 MDM7xx.COM	(now have a modified .COM file)
;
; =   =	  =   =	  =   =	  =   =	  =   =	  =   =	  =   =	  =   =	  =   =
;
; 07/01/83 - Revised to work with MDM7xx	- Irv Hoff
; 06/22/83 - Revised to work with MDM710	- Irv Hoff
; 05/25/83 - Revised to work with MDM709	- Irv Hoff
; 04/15/83 - Revised to work with MDM708	- Irv Hoff
; 04/11/83 - Updated to work with MDM707	- Irv Hoff
; 04/04/83 - Updated to work with MDM706	- Irv Hoff
; 02/27/83 - Updated to work with MDM705	- Irv Hoff
; 08/16/83 - Modified MDM7xx for OTRONA		- Frank Miller
;
; =   =	  =   =	  =   =	  =   =	  =   =	  =   =	  =   =	  =   =	  =
;
BELL:		EQU	07H		;bell
CR:		EQU	0DH		;carriage return
ESC:		EQU	1BH		;escape
LF:		EQU	0AH		;linefeed
;
YES:		EQU	0FFH
NO:		EQU	0
;
;
PORT:		EQU	002H		;SUPER QUAD serial output port
MODCTL1:	EQU	PORT+1		;Modem control port
MODDATP:	EQU	PORT		;Modem data port
MODCTL2:	EQU	PORT+1		;Modem control port
MODRCVB:	EQU	01H		;Your bit to test for receive
MODRCVR:	EQU	01H		;Your value when receive ready
MODSNDB:	EQU	04H		;Your bit to test for send
MODSNDR:	EQU	04H		;Your value when send ready	       

;
;
		ORG	100H
;
;
; Change the clock speed as needed for your system.
;
		DS	3	;(for  "JMP   START" instruction)
;
PMMIMODEM:	DB	NO	;yes=PMMI S-100 Modem			103H
SMARTMODEM:	DB	YES	;yes=HAYES Smartmodem, no=non-PMMI	104H
TOUCHPULSE:	DB	'P'	;T=touch, P=pulse (Smartmodem-only)	105H
CLOCK:		DB	60	;clock speed in MHz x10, 25.5 MHz max.	106H
				;20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
MSPEED:		DB	8	;0=110 1=300 2=450 3=600 4=710 5=1200	107H
				;6=2400 7=4800 8=9600 9=19200 default
BYTDLY:		DB	1	;0=0 delay  1=10ms  5=50 ms - 9=90 ms	108H
				;default time to send character in ter-
				;minal mode file transfer for slow BBS.
CRDLY:		DB	1	;0=0 delay 1=100 ms 5=500 ms - 9=900 ms 109H
				;default time for extra wait after CRLF
				;in terminal mode file transfer
NOOFCOL:	DB	5	;number of DIR columns shown		10AH
SETUPTST:	DB	YES	;yes=user-added Setup routine		10BH
SCRNTEST:	DB	YES	;Cursor control routine			10CH
ACKNAK:		DB	YES	;yes=resend a record after any non-ACK	10DH
				;no=resend a record after a valid NAK
BAKUPBYTE:	DB	YES	;yes=change any file same name to .BAK	10EH
CRCDFLT:	DB	YES	;yes=default to CRC checking		10FH
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	110H
CONVBKSP:	DB	NO	;yes=convert backspace to rub		111H
TOGGLEBK:	DB	YES	;yes=allow toggling of bksp to rub	112H
ADDLF:		DB	NO	;no=no LF after CR to send file in	113H
				;terminal mode (added by remote echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR	114H
TRANLOGON:	DB	YES	;yes=allow transmission of logon	115H
				;write logon sequence at location LOGON
SAVCCP:		DB	YES	;yes=do not overwrite CCP		116H
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	117H
				;no=external command if EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:		DB	YES	;yes=printer available on printer port	119H
XOFFTST:	DB	NO	;yes=chcks for XOFF from remote while	11AH
				;s%nding a file in termi!@@&!@B xHfsBA    8>" >@C>8" >p> !rO  &!>9>"!>>  8>  &!@`@bcfs`   8 >   !> #>@bc>0 0 !pOH`B@pGfs`   pG 08>82 !>A> >&8 'fO`yfs " >"  !> 8 `O`yfs " >"  !> 8 bOr@pNfs !O? ?> '>9?> >2 8> !OB@pBBpfs C!O? C?>f0  0>" >!> !>!OF@`pNfs A!O? A?> '>   OFpNfs !O? ?>   !> O Bxafs !O? ?>p !> > >2 "" OxBpNfs !O? ?>8 >"!>>   ! Ox`pNfs 	!O? 	?>@ > > >2 "" O`pNfs !O? ?> '> >0880  OfOHC&@@fpG@IyO 08 ?>  >  xO@ @@fpGHC@@fpG   >!>8 >2`f@ &@@ffx@ @@ffx?9>`   >  & >&89> OfHC&@@ffxSCRNTEST:	DB	YES	;Cursor control routine			10CH
ACKNAK:		DB	YES	;yes=resend a record after any non-ACK	10DH
				;no=resend a record after a valid NAK
BAKUPBYTE:	DB	YES	;yes=change any file same name to .BAK	10EH
CRCDFLT:	DB	YES	;yes=default to CRC checking		10FH
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	110H
CONVBKSP:	DB	NO	;yes=convert backspace to rub		111H
TOGGLEBK:	DB	YES	;yes=allow toggling of bksp to rub	112H
ADDLF:		DB	NO	;no=no LF after CR to send file in	113H
				;terminal mode (added by remote echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR	114H
TRANLOGON:	DB	YES	;yes=allow transmission of logon	115H
				;write logon sequence at location LOGON
SAVCCP:		DB	YES	;yes=do not overwrite CCP		116H
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	117H
				;no=external command if EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:		DB	YES	;yes=printer available on printer port	119H
XOFFTST:	DB	NO	;yes=chcks for XOFF from remote 6H
JMP$INLNCOMP:	DS	3		;				189H
JMP$INMODEM	DS	3		;				18CH
JMP$NXTSCRN:	DS	3		;				18FH
JMP$TIMER:	DS	3		;				192H
;
;
; Clear sequences -- CLREOS is clear to end of screen, CLRSCRN is clear
; entire screen.  Last entry must be 0.	 Any other 0's act as NOP's.
;
CLREOS:		CALL	JMP$ILPRT	;				195H
		DB	017H,0,0,0,0	;				198H
		RET			;				19DH
;
CLRSCRN:	CALL	JMP$ILPRT	;				19EH
		DB	01AH,0,0,0,0	;				1A1H
		RET			;				1A6H
;
;
SYSVER:		CALL	JMP$ILPRT	;				1A7H
		DB	'Version for ADVANCED DIGITAL SSLAVE PORT 02H'
;
	DB	CR,LF,0
		RET
;.....
;
;
;----------------------------------------------------------------------$ဟ! 0  	0	   	 	 		   		    	 '		 0	 ' 	    		9' 	 ကZI$Ii$H	%KI $@I-$ZI$Ii$	INl-
-$
nl,.
.d
bSCRNTEST:	DB	YES	;Cursor control routine			10CH
ACKNAK:		DB	YES	;yes=resend a record after any non-ACK	10DH
				;no=resend a record after a valid NAK
BAKUPBYTE:	DB	YES	;yes=change any file same name to .BAK	10EH
CRCDFLT:	DB	YES	;yes=default to CRC checking		10FH
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	110H
CONVBKSP:	DB	NO	;yes=convert backspace to rub		111H
TOGGLEBK:	DB	YES	;yes=allow toggling of bksp to rub	112H
ADDLF:		DB	NO	;no=no LF after CR to send file in	113H
				;terminal mode (added by remote echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR	114H
TRANLOGON:	DB	YES	;yes=allow transmission of logon	115H
				;write logon sequence at location LOGON
SAVCCP:		DB	YES	;yes=do not overwrite CCP		116H
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	117H
				;no=external command if EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:		DB	YES	;yes=printer available on printer port	119H
XOFFTST:	DB	NO	;yes=chcks for XOFF from remote DE
;	  OUT	MODCTL1
;	  MVI	A,14H		;SELECT REG.
;	  OUT	MODCTL1
;	  MVI	A,84H		;SET ASCII PARAMETERS
;	  OUT	MODCTL1
;	  MVI	A,03H		;SELECT REG.
;	  OUT	MODCTL1
;	  MVI	A,0C1H		;ENABLE RECEIVE
;	  OUT	MODCTL1
;	  MVI	A,05H		;SELECT REG.
;	  OUT	MODCTL1
;	  MVI	A,0EAH		;ENABLE SEND, DTR, RTS
;	  OUT	MODCTL1
;
INITMOD1:
;	  MVI	A,1		;SET FILE TRANSFER TIME
;	  STA	MSPEED
;	  MVI	A,45H
;	  OUT	10H		;SEND TO 'CTC' TIMER

INITMOD2:
;	  MVI	A,020H		;INITIALIZE TO 1200 BAUD
;	  OUT	10H		;SEND TO 'CTC' TIMER
	  RET
;.....
;
;
; Sets the modem speed via the SET comd0 	䟟#$39< 39 1 $! !0 $! 9 110	䟟8<##! $#	䟟39$ 9 	䟟8<##! $!9 1䟟#$39< 39 1䟟8<##! $!#!8  8  <	09< 39 1 $'8'<	<80	90#  䟟39䐈䟟!!8  0 $10  <8'䟟8<##! $!#!8  䟟39䐁䟟!!8  䟟8<##! $!#!8  䟟39䐌䟟!!8  䟟8<##! $!#!8  䟟39䐄䟟!!8  9600
	  CALL	JMP$ILPRT	;ALL MATCHES FAILED, TELL OPERATOR
	  DB	'++ Incorrect entry ++',CR,LF,BELL,0
	  JMP	SETUPR		;TRY AGAIN
;
;	  CALL JMP$ILPRT	;MUST SET BAUD RATE EXTERNALLY
;	  DB	'++ Please use manual baud rate setup ++',CR,LF,BELL,0
 OK300:	  MVI	A,1
	  LHLD	BD300
	  JMP	LOADBD
 
 OK600:	  MVI	A,3
	  LHLD	BD600
	  JMP	LOADBD
 
 OK1200:  MVI	A,5
	  LHLD	BD1200
	  JMP	LOADBD
 
 OK9600:  MVI	A,8
	  LHLD	BD9600
 
 LOADBD:  STA	INITMOD1+1	;CHANGE TIME-TO-SEND TO MATCH BAUDRATE
	  MOV	A,L		;GET BAUDRATE BYTE
	  STA	INITMOD2+1	;SEND TO 'CTC' FOR NEW BAUDRATE
	  JMP	INITMOD1	;REINITIALIZE TO NEW BAUDRATE, THEN DONE
 
 
; TABLE OF BAUDRATE PARAMETERS
 
BD300:	  DW	05EH
BD600:	  DW	06EH
BD1200:	  DW	07EH
BD9600:	  DW	0EEH
;
BAUDBUF:  DB	10,0
	  DS	10
;
;-------------------------------$ZI$Ii$H	%KI $@I-$ZI$4(4(Q s9{Ks)q)+!qKcKk+s3{s{+{0hQKs++y	Kc{k+a+qK1Ks9C)C+kk{#+hhQhis is unavailable without a spcial address change.
;
SPCLMENU: RET
;
;----------------------$ZI$Ii$H	%KI $@I-$ZI$Ii$N 3B  93 B3	B 2	xyp @0y0 1 NNNNIxyp @0p  90 1 NI>