; CP4TYP.ASM
;	KERMIT - (Celtic for "FREE")
;
;	This is the CP/M-80 implementation of the Columbia University
;	KERMIT file transfer protocol.
;
;	Version 4.0
;
;	Copyright June 1981,1982,1983,1984
;	Columbia University
;
; Originally written by Bill Catchings of the Columbia University Center for
; Computing Activities, 612 W. 115th St., New York, NY 10025.
;
; Contributions by Frank da Cruz, Daphne Tzoar, Bernie Eiben,
; Bruce Tanner, Nick Bush, Greg Small, Kimmo Laaksonen, Jeff Damens, and many
; others. 
;
;	This is the header file for building the system-dependent overlay
;	for KERMIT.  It contains the definitions used to select the target
;	system, and collects (via INCLUDE or LINK directives) the remaining
;	code.  If the target system is one of the supported systems
;	described below, then this is the only file that needs to be
;	edited.
;
; revision history:
; edit 5: October 13, 1984 by L M Jones, JCC, for New York Botanical Garden
;	Add support for CPT-85xx series of word processors when running CP/M.
;
; edit 4: August 29, 1984 by Bdale Garbee @ CMU
;	Add support for Digicomp Delphi 100 and Netronics Smartvid terminal.
;
; edit 3: July 27, 1984 (CJC)
;	Shuffle files around for easier assembly by both M80 and LASM.
;
; edit 2: June 4, 1984 [Toad Hall]
;	Added Morrow Decision I (the big S100 bus sucker, not the
;	little single motherboard one); added Toad Hall TACTrap to deal
;	with those working through a TAC and its intercept character.
;
; edit 1: May, 1984 (CJC)
;	extracted from CPMBASE.M80 version 3.9; modifications are described
;	in the accompanying .UPD file.
;

FALSE	EQU	0
TRUE	EQU	NOT FALSE

;
; Assembler type.  Define the appropriate one TRUE, the rest FALSE.  (We can't
; use ASM, because it cannot handle multiple input files)
mac80	EQU	FALSE		; For assembly via MAC80 cross-assembler.
m80	EQU	FALSE		; For assembly via Microsoft's M80.
lasm	EQU	TRUE		; For assembly via LASM, a public-domain
				; assembler.

;
;	Address at which the overlay should be loaded.	This will not
;	change often (no more than once per version of KERMIT); it should
;	be updated when a new version of KERMIT is released.
ovladr	EQU	3400H		; value for KERMIT v4.00

;Which CP/M system hardware are we building KERMIT-80 for?
;One of the following should be TRUE, the rest FALSE:
;
;We have basically three "classes" of systems:

;Systems supporting the IO-redirection via I/O-Byte

robin	EQU	FALSE		;DEC VT180 = Generic + VT100 screen control
gener	EQU	FALSE		;"Generic" Kermit-80, CP/M calls only.
				; (terminal required)
dmII	EQU	FALSE		;"Generic" KERMIT-80 for DECMATE II.
mikko	EQU	FALSE		;"Generic" KERMIT-80 for MikroMikko

IF robin OR dmII OR gener OR mikko
iobyt	EQU	TRUE		;Short conditional for above
inout	EQU	FALSE
ENDIF;robin OR dmII OR gener

;.. and Systems supporting direct IN / OUT handling of ports
brain	EQU	FALSE		;For Intertec SuperBrain.
vector	EQU	FALSE		;For Vector Graphics.
heath	EQU	FALSE		;For Heath/Zenith H89.
z100	EQU	FALSE		;For Z-100 under CP/M-85.
trs80lb EQU	FALSE		;For Lifeboat 2.25C CP/M Display
trs80pt EQU	TRUE		;For Pickles + Trout CP/M Display
telcon	EQU	FALSE		;For TELCON Zorba portable
kpII	EQU	FALSE		;Kaypro-II
bbII	EQU	FALSE		;BigBoard II (terminal required)
mmdI	EQU	FALSE		;Morrow Micro Decision I (terminal required)
mdI	EQU	FALSE		;Morrow Decision I (the big sucker)
				; (terminal required) [Toad Hall]
delphi	EQU	FALSE		;Digicomp Delphi 100 (terminal required)
cpt85xx EQU	FALSE		;CPT-85xx word processor w/CPM (set ADM3A true)

trs80	EQU	trs80lb OR trs80pt ; if either, flag TRS-80 system.

IF brain OR vector OR heath OR z100 OR trs80 OR telcon OR kpII
inout	EQU	TRUE		;Short conditional for above
iobyt	EQU	FALSE
ENDIF;brain OR vector OR heath OR z100 OR trs80 OR telcon OR kpII

IF bbII OR mmdI OR mdI OR delphi OR cpt85xx	;running out of room
inout	EQU	TRUE		;Short conditional for above
iobyt	EQU	FALSE
ENDIF;bbII OR mmdI OR mdI OR delphi OR cpt85xx

;.. and Systems doing neither...
osi	EQU	FALSE		;For Ohio Scientific.
osbrn1	EQU	FALSE		;For Osborne 1
cpm3	EQU	FALSE		;"Generic" Kermit-80 for CP/M 3.0 (CP/M Plus)
				; (terminal required)
apmmdm	EQU	FALSE		;jb Micromodem II in slot 2
ap6551	EQU	FALSE		;jb apple with 6551 ACIA in serial interface
IF ap6551			;jb eg. Apple SSC, Videx PSIO, Basis 108
apslot	EQU	2		;jb set equal to slot containing serial card
				;jb  set to 1 for Basis built-in port
ENDIF;jb ap6551

apple	EQU	apmmdm OR ap6551 ; flag apple system if either selected
IF osi OR apple OR osbrn1 OR cpm3
iobyt	EQU	FALSE
inout	EQU	FALSE
ENDIF;osi OR apple OR osbrn1 OR cpm3

;.. and for Micros, like the MDI, which have "terminals of choice", you must
;select one of these in addition to selecting the micro itself.
;Also select a terminal for "gener" and "cpm3": use "crt" for the true generic.
crt	EQU	FALSE		;Basic CRT, no cursor positioning
adm3a	EQU	FALSE		;Adm3a Display (or CPT built-in display)
smrtvd	EQU	FALSE		;Netronics Smartvid terminal.
tvi925	EQU	FALSE		;TVI925 Display
				; (works for Freedom 100 also)	[Toad Hall]
vt52	EQU	FALSE		;VT52 or equivalent (or H19)
vt100	EQU	FALSE		;VT100 or equivalent

; Toad Hall TAC Trap:  If you're going through a TAC, it will
; cough on its Intercept Character (usually a @ (* - 40H)).  Sending it
; twice forces the TAC to recognize it as a valid ASCII character,
; and it'll send only one on to the host.  If you've SET the TACTrap
; to OFF, it will be a null character, and nothing will happen.	 If you
; set it on, it will be your selected TAC intercept character (or will
; default to the common intercept char, '@'.
; If you never expect to have to work through such a beastie, just set
; TAC to false and forget all this mess.  [Toad Hall]

tac	EQU	TRUE		; gonna work through a TAC?
tacval	EQU	'@'		;Typical TAC intercept character

; Processor speed in units of 100KHz (for bbII, kpII, & cpt85xx timing loop)
;cpuspd	 EQU	 20		; CPT-85xx: 2.0 MHz ('cause of integral video?)
;cpuspd	 EQU	 25		; original Kaypro II: 2.5 MHz
cpuspd	 EQU	 40		; bbII: 4.0 MHz	 [also Kaypro 10]

cp4ker	EQU	FALSE		; building the system-dependent part...

IF lasm
	LINK	CP4DEF
ENDIF;lasm  [Toad Hall]

; If we're still here, must be M80 or MAC80.  Collect the rest of
; the sources.
	INCLUDE CP4DEF.ASM	; common definitions
	INCLUDE CP4LNK.ASM	; linkage area description
	INCLUDE CP4SYS.ASM	; system-dependent code and tables
	END
